<?php
// Set content type to HTML, as this file will now render the full HTML page
header('Content-Type: text/html; charset=UTF-8');

$install_dir = 'C:/wamp64'; // Đường dẫn thư mục cài đặt WAMP của bạn
$www_dir = $install_dir . '/www'; 

$projects = [];

// Lấy danh sách các mục trong thư mục www
// SCANDIR_SORT_ASCENDING để sắp xếp theo tên
$items = scandir($www_dir, SCANDIR_SORT_ASCENDING); 

if ($items === false) {
    $projects = []; 
} else {
    foreach ($items as $item) {
        // Bỏ qua các thư mục đặc biệt và file không phải là dự án
        if ($item === '.' || $item === '..' || $item === 'index.php' || $item === 'index.html' || $item === 'favicon.ico' || $item === 'system') { 
            continue;
        }
        
        $path = $www_dir . '/' . $item;

        if (is_dir($path)) { 
            $projectName = ucfirst(str_replace(['_', '-'], ' ', $item)); 
            $projects[] = [
                'folderName' => $item,
                'projectName' => $projectName,
                'url' => '/' . $item . '/'
            ]; 
        }
    }
}

// Kiểm tra địa chỉ IP của client
$client_ip = $_SERVER['REMOTE_ADDR'];
$is_local = ($client_ip === '127.0.0.1' || $client_ip === '::1');

// --- LOGIC: Xử lý hiển thị IP dựa trên client_ip ---
$server_ip_display = '';

if ($is_local) { // Nếu truy cập từ localhost
    $found_ips = [];
    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') { 
        $command = 'ipconfig';
        @exec($command, $output); 

        if (!empty($output)) {
            foreach ($output as $line) {
                if (preg_match('/IPv4 Address[.\s]+:\s*([\d.]+)/i', $line, $matches)) {
                    $ip = $matches[1];
                    if ($ip !== '127.0.0.1') {
                        $found_ips[] = $ip;
                    }
                }
            }
        }
    } else { 
        $command = 'ip -4 addr show';
        @exec($command, $output);
        if (!empty($output)) {
            foreach ($output as $line) {
                if (preg_match('/inet ([\d.]+)/', $line, $matches)) {
                    $ip = $matches[1];
                    if ($ip !== '127.0.0.1') {
                        $found_ips[] = $ip;
                    }
                }
            }
        }
    }
    
    $found_ips = array_unique($found_ips);
    if (empty($found_ips)) {
        $server_ip_display = "Không thể lấy IP hoặc chỉ có IPv6 (::1)";
    } else {
        $server_ip_display = implode(', ', $found_ips);
    }

} else { // Nếu truy cập từ mạng LAN
    $server_ip_display = htmlspecialchars($_SERVER['SERVER_ADDR']);
}
// --- KẾT THÚC LOGIC ---

?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>App Gallery - AppGini.VN</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        /* No projects message */
        .no-projects {
            text-align: center;
            font-size: 1.2em;
            color: #888;
            margin-top: 20px;
        }
        /* Custom styles for the panel */
        .app-panel {
            background-color: #f8fafc; /* Tailwind slate-50 */
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            padding: 1.5rem;
            border: 1px solid #e2e8f0; /* Tailwind slate-200 */
        }
        .app-panel-header {
            font-size: 1.75rem; /* text-3xl */
            font-weight: 700; /* font-bold */
            color: #334155; /* slate-700 */
            margin-bottom: 1.5rem; /* mb-6 */
            text-align: center;
            padding-bottom: 1rem;
            border-bottom: 2px solid #cbd5e1; /* slate-300 */
        }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-100 to-purple-200 min-h-screen flex items-center justify-center py-10">
    <div class="bg-white p-8 md:p-12 rounded-lg shadow-2xl max-w-5xl w-full text-center">
        <h1 class="text-4xl md:text-5xl font-extrabold text-gray-800 mb-4 leading-tight">
            Chào mừng bạn đến với App Gallery !
        </h1>
        <p class="text-lg text-gray-600 mb-2">
            Địa chỉ IP của Server: <strong class="text-blue-700"><?php echo htmlspecialchars($server_ip_display); ?></strong>
        </p>
        <p class="text-lg text-gray-600 mb-10">
            Dưới đây là danh sách các ứng dụng/dự án đang hoạt động. Vui lòng chọn một để khám phá!
        </p>

        <?php if ($is_local): // Chỉ hiển thị nút phpMyAdmin nếu truy cập từ localhost ?>
            <div class="mb-8"> 
                <a href="/phpmyadmin/" target="_blank" class="block">
                    <button class="bg-green-600 hover:bg-green-700 text-white font-bold py-4 px-6 rounded-lg shadow-xl hover:shadow-2xl transition duration-300 transform hover:scale-105 w-full max-w-sm mx-auto text-xl">
                        Truy cập phpMyAdmin
                    </button>
                </a>
            </div>
        <?php endif; ?>

        <div class="app-panel mt-8"> <h2 class="app-panel-header">Danh sách ứng dụng</h2>
            <div id="projects-container" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 md:gap-8">
                <?php if (empty($projects)): ?>
                    <p class="no-projects col-span-full">Không tìm thấy dự án nào trong thư mục www.</p>
                <?php else: ?>
                    <?php foreach ($projects as $project): ?>
                        <a href="<?php echo htmlspecialchars($project['url']); ?>" class="block">
                            <button class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 px-6 rounded-lg shadow-lg hover:shadow-xl transition duration-300 ease-in-out transform hover:scale-105 w-full text-xl">
                                <?php echo htmlspecialchars($project['projectName']); ?>
                            </button>
                        </a>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="mt-16 text-sm text-gray-500">
            <p>&copy; <?php echo date("Y"); ?> AppGini.VN. Được cung cấp bởi WampServer.</p>
            <p>Landing page này được tối ưu hóa cho truy cập nội bộ.</p>
        </div>
    </div>
</body>
</html>