<?php
require_once 'config.php'; // Nạp file cấu hình

// Hàm để thiết lập kết nối đến cơ sở dữ liệu MySQL
function getDbConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);

    // Kiểm tra kết nối
    if ($conn->connect_error) {
        // Ghi log lỗi kết nối thay vì hiển thị trực tiếp ra ngoài trong môi trường production
        error_log("Database connection error: " . $conn->connect_error);
        http_response_code(500); // Internal Server Error
        echo json_encode(["message" => "Lỗi nội bộ máy chủ. Vui lòng thử lại sau."]);
        exit();
    }
    // Đặt bộ ký tự cho kết nối để tránh lỗi font tiếng Việt
    $conn->set_charset("utf8");
    return $conn;
}

// Hàm hỗ trợ để trả về phản hồi lỗi dưới dạng JSON và dừng script
function respondWithError($statusCode, $message) {
    http_response_code($statusCode);
    echo json_encode(["message" => $message]);
    exit();
}

// Hàm giải mã JWT (JSON Web Token)
// LƯU Ý QUAN TRỌNG: Đây là một triển khai JWT CƠ BẢN và không bao gồm đầy đủ các bước xác minh chữ ký.
// Trong môi trường PRODUCTION, BẠN NÊN SỬ DỤNG THƯ VIỆN JWT CỦA BÊN THỨ BA ĐÁNG TIN CẬY
// ví dụ: `composer require firebase/php-jwt` và sử dụng nó để giải mã và xác minh token.
function decodeJwt($token) {
    try {
        // Tách header, payload và signature
        list($header, $payload, $signature) = explode('.', $token);

        // Giải mã payload
        $decodedPayload = json_decode(base64_decode($payload), true);

        // --- Kiểm tra chữ ký (Quan trọng cho bảo mật) ---
        // Trong môi trường thực tế, bạn sẽ cần tính toán lại chữ ký và so sánh nó.
        // Đây chỉ là một ví dụ minh họa và CẦN ĐƯỢC THAY THẾ bằng logic xác minh chữ ký mạnh mẽ.
        // $expectedSignature = base64_encode(hash_hmac('sha256', "$header.$payload", JWT_SECRET_KEY, true));
        // if ($signature !== trim($expectedSignature, '=')) {
        //     error_log("JWT Signature verification failed.");
        //     return null; // Chữ ký không hợp lệ
        // }
        // --- Kết thúc kiểm tra chữ ký ---

        // Kiểm tra thời hạn hết hạn của token
        if (isset($decodedPayload['exp']) && $decodedPayload['exp'] < time()) {
            error_log("JWT Token expired.");
            return null; // Token đã hết hạn
        }

        return $decodedPayload; // Trả về payload đã giải mã
    } catch (Exception $e) {
        error_log("Error decoding JWT: " . $e->getMessage());
        return null; // Lỗi khi giải mã token
    }
}
?>
