<?php
// Đặt header để cho phép CORS và định dạng phản hồi JSON
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS"); // Chỉ cho phép POST và OPTIONS cho endpoint đăng nhập
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Xử lý yêu cầu OPTIONS (pre-flight request của CORS)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Nạp các file cần thiết
require_once 'auth.php';          // Để sử dụng hàm loginUser()
require_once 'db_connection.php'; // Để sử dụng hàm respondWithError()

// Chỉ xử lý yêu cầu POST cho đăng nhập
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Đọc dữ liệu JSON từ request body
    $data = json_decode(file_get_contents("php://input"), true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        respondWithError(400, "Dữ liệu JSON không hợp lệ."); // 400 Bad Request
    }

    $username = isset($data['username']) ? $data['username'] : '';
    $password = isset($data['password']) ? $data['password'] : '';

    // Kiểm tra xem username và password có được cung cấp không
    if (empty($username) || empty($password)) {
        respondWithError(400, "Vui lòng cung cấp tên người dùng và mật khẩu.");
    }

    // Gọi hàm loginUser để xác thực và tạo token
    $token = loginUser($username, $password);

    if ($token) {
        http_response_code(200); // 200 OK
        echo json_encode(["message" => "Đăng nhập thành công", "token" => $token]);
    } else {
        respondWithError(401, "Tên người dùng hoặc mật khẩu không đúng."); // 401 Unauthorized
    }
} else {
    // Phương thức không được hỗ trợ cho endpoint này
    respondWithError(405, "Phương thức " . $_SERVER['REQUEST_METHOD'] . " không được hỗ trợ cho endpoint đăng nhập.");
}
?>
